define(['angular', 'app'], function (angular, app) {
	'use strict';

	app.directive('validationSummary', function($q, $timeout, focusService) {
		return {
			restrict: 'AE',
			link: function(scope, elem, attr) {
				var parentForm = angular.element(elem.parents().closest('form')[0]);
				var formController = parentForm.controller('form');
				formController.validationSummary = {};
				formController.validationSummary.validate = function(errorGroup) {
					//make sure a digest loop has run to update form validation
					var defer = $q.defer();
					$timeout(function(){
						scope.errors = [];
						
						var orderedNodes = parentForm.find("[error-handling]").andSelf().filter("[error-handling]").toArray();
						
						orderedNodes.forEach(function(errorableNode) {

							var controller = angular.element(errorableNode).controller("ngModel") || angular.element(errorableNode).controller("form");

							if(controller && controller.errorHandling) {
								var errorHandling = controller.errorHandling;
								var errorKeys = Object.keys(controller.$error);
								var currentErrors = [];
								var currentErrorPriority = Infinity;
								errorKeys.forEach(function(errorKey) {
									var currentErrorHandling = errorHandling[errorKey];
									if(controller.$error[errorKey]) {
										if(currentErrorHandling && currentErrorHandling.priority > 0 && (!errorGroup || currentErrorHandling.group === errorGroup)) {
											if(currentErrorHandling.priority < currentErrorPriority) {
												currentErrors = [currentErrorHandling];
												currentErrorPriority = currentErrorHandling.priority;
											} else if(currentErrorHandling.priority === currentErrorPriority) {
												currentErrors.push(errorHandling[errorKey]);
											}
										}
									}
								});

								currentErrors.forEach(function(error) {
									scope.errors.push(error.message);
								});
							}
						});

						if(scope.errors.length !== 0){
							focusService.focusElement('.validation-summary h5');
							defer.reject();
						} else {
							defer.resolve();
						}
					});

					return defer.promise;
				};

				formController.validationSummary.summarizeAsync = function(promises) {
					scope.errors = [];

					$q.all(promises).then(
						function() {},
						function(errors) {
							function appendErrorsToSummary(requestErrors){
								requestErrors.errors.forEach(function(error) {
									if (angular.isDefined(error.errorMessage)) {
										scope.errors.push(error.errorMessage);
									}
								});
							};
							if (errors && typeof errors !== "string") {
								if(Array.isArray(errors)) {
									errors.forEach(function(requestErrors){
										appendErrorsToSummary(requestErrors);
									});
								} else if(errors["objectType"] === "ValidationErrors" || errors["objectType"] === "LocalValidationErrors"){
									appendErrorsToSummary(errors);
								} else {
									for(var key in errors) {
										if(errors.hasOwnProperty(key)) {
											appendErrorsToSummary(errors[key]);
										}
									}
								}

								focusService.focusElement('.validation-summary h5');
							}
						});

				};

				formController.validationSummary.clear = function() {
					scope.errors = [];
				};


			},
			templateUrl: 'src/ui-components/form/validation/validation-summary/validation-summary_template.html'
		};
	});
});